<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:HTML='http://www.w3.org/Profiles/XHTML-transitional' xmlns:dt='urn:schemas-microsoft-com:datatypes'>

	<xsl:output method='html'/>



	<xsl:include href='../core/controls.xslt'/>



	<xsl:variable name='settings' select='document("../../ide/settings/settings.xml")/settings/customize/data/ctmCommands'/>



	<xsl:template match='@* | node()'>

		<xsl:copy><xsl:apply-templates select="@* | node()"/></xsl:copy>

	</xsl:template>

	

	<xsl:strip-space elements="*"/>





	<xsl:template match='commandbarset'>

		<xsl:call-template name='commandBarSet'/>

	</xsl:template>



	<xsl:template match='commandbar'>

		<xsl:call-template name='commandBar'/>

	</xsl:template>



	<xsl:template match='combobox[parent::commandbar]'>

		<xsl:call-template name='commandBarComboBox'>

			<xsl:with-param name='comboBoxNode' select='.'/>

		</xsl:call-template>

	</xsl:template>



	<xsl:template match='command[parent::commandbar]'>

		<xsl:choose>

			<xsl:when test='command'>

				<xsl:call-template name='commandBarItem'>

					<xsl:with-param name='cmd' select='command[1]'/>

				</xsl:call-template>

			</xsl:when>

			<xsl:otherwise>

				<xsl:call-template name='commandBarItem'>

					<xsl:with-param name='cmd' select='.'/>

				</xsl:call-template>

			</xsl:otherwise>

		</xsl:choose>

	</xsl:template>



	<xsl:template match='command[parent::command]'>

		<xsl:if test='position() > 1'>

			<xsl:call-template name='commandListItem'/>

		</xsl:if>

	</xsl:template>

	

	<xsl:template match='separator'>

		<xsl:call-template name='separator'/>

	</xsl:template>





	<xsl:template name='commandBarSet'>

		<table class="toolbarset" id='{@id}' cellpadding="0" cellspacing="0" border="0">

			<tr class="toolbarset_row">

				<xsl:apply-templates/>

				<td class="commandBar_filler"></td>

			</tr>

		</table>

	</xsl:template>



	<xsl:template name='commandBar'>

		<td class="toolbarset_cell">

<!--			<table class="toolbar" id='{@id}' cellpadding="0" cellspacing="2" border="0"> -->

			<table class="toolbar" id='{@id}' cellpadding="0" cellspacing="0" border="0">

				<tr>

					<td><img src="../apt/images/commandbarhandle.gif"/></td>

					<xsl:apply-templates/>

<!--					<td class="commandBar_filler"></td> -->

				</tr>

			</table>

		</td>

	</xsl:template>



	<xsl:template name='commandBarComboBox'>

		<xsl:param name='comboBoxNode'/>



		<xsl:variable name='cbID' select='$comboBoxNode/@comboboxid'/>



		<td nowrap="1" id="toolBar_{$cbID}" comboboxid="{$cbID}" level="0">

			<span>

				<xsl:call-template name='comboBox'>

					<xsl:with-param name='comboBoxNode' select='$comboBoxNode'/>

				</xsl:call-template>

			</span>

		</td>

	</xsl:template>



	<xsl:template name='comboBoxOptions'>

		<xsl:param name='id'/>

		<xsl:param name='selected'/>		<!-- Selected option value -->

		<xsl:param name='comboBoxNode'/>	<!-- The <combobox> node in XML document if exists -->

		<xsl:param name='comboBoxDefine'/>

		<xsl:param name='comboBoxResource'/>



		<xsl:variable name='selectedName' select='substring-before($selected, "=")'/>

		<xsl:variable name='selectedValue' select='substring-after($selected, "=")'/>



		<xsl:if test='$comboBoxNode and $comboBoxNode/option'>

			<xsl:apply-templates select='$comboBoxNode/option'>

				<xsl:with-param name='selectedName' select='$selectedName'/>

				<xsl:with-param name='selectedValue' select='$selectedValue'/>

			</xsl:apply-templates>

		</xsl:if>



		<xsl:choose>

			<xsl:when test='$comboBoxDefine and $comboBoxDefine/option'>

				<xsl:apply-templates select='$comboBoxDefine/option'>

					<xsl:with-param name='selectedName' select='$selectedName'/>

					<xsl:with-param name='selectedValue' select='$selectedValue'/>

				</xsl:apply-templates>

			</xsl:when>

			<xsl:when test='$comboBoxResource and $comboBoxResource/option'>

				<xsl:apply-templates select='$comboBoxResource/option'>

					<xsl:with-param name='selectedName' select='$selectedName'/>

					<xsl:with-param name='selectedValue' select='$selectedValue'/>

				</xsl:apply-templates>

			</xsl:when>

		</xsl:choose>

	</xsl:template>



	<xsl:template name='commandBarItem'>

		<xsl:param name='cmd'/>



		<xsl:variable name='cmdID' select='$cmd/@commandid'/>

		<xsl:variable name='cmdNode' select='$resource/commands//command[@id = $cmdID]'/>

		<xsl:variable name='cmdStatus' select='$cmd/@status | $cmdNode/@status'/>

		

		<td nowrap="1" id="toolBar_{$cmdNode/@id}" commandid="{$cmdNode/@id}" title="{$cmdNode/@tooltip}" level="0" status="{$cmdStatus}">

			<xsl:apply-templates select='$cmdNode/@name | $cmdNode/@action | $cmdNode/@shortcut | $cmdNode/@image | $cmdNode/@type | $cmd/@checked'/>

			<xsl:attribute name='class'>toolbar_common commandbar_item_<xsl:value-of select='$cmdStatus'/></xsl:attribute>

			

			<span class="commandbar_item_content"><img src="../apt/images/{$cmdNode/@image}.gif" align="middle"/></span>

			

			<xsl:call-template name='commandList'>

				<xsl:with-param name='cmdID' select='$cmdID'/>

			</xsl:call-template>

		</td>

	</xsl:template>



	<xsl:template name='commandList'>

		<xsl:param name='cmdID'/>



		<xsl:if test='command[position() > 1]'>

			<span class="commandbar_item_arrow"><img src="../apt/images/commandlistdown.gif" align="middle"/></span>



			<div class="commandlist_hidden" id="toolBar_{$cmdID}_commandList">

				<table cellpadding="0" cellspacing="0">

					<xsl:apply-templates/>

				</table>

			</div>

		</xsl:if>

	</xsl:template>



	<xsl:template name='commandListItem'>

		<xsl:variable name='cmdID' select='@commandid'/>

		<xsl:variable name='cmdNode' select='$resource/commands//command[@id = $cmdID]'/>

		<xsl:variable name='level' select='count(ancestor::*[name()="command"])'/>

		<xsl:variable name='cmdStatus' select='@status | $cmdNode/@status'/>



		<tr id="toolBar_{$cmdNode/@id}" commandid="{$cmdNode/@id}" title="{$cmdNode/@tooltip}" level='{$level}' status="{$cmdStatus}">

			<xsl:apply-templates select='$cmdNode/@name | $cmdNode/@action | $cmdNode/@shortcut | $cmdNode/@image | $cmdNode/@type | @checked'/>

			<xsl:attribute name='class'>commandlist_common commandlist_item_<xsl:value-of select='$cmdStatus'/></xsl:attribute>

			

			<td class="command_icon_common command_icon">

				<div>

					<xsl:choose>

						<xsl:when test='$cmdNode/@type = "check" and @checked'><img src="../apt/images/check.gif"/></xsl:when>

						<xsl:when test='not($cmdNode/@type) and $cmdNode/@image'><img src="../apt/images/{$cmdNode/@image}.gif"/></xsl:when>

						<xsl:otherwise>&#160;</xsl:otherwise>

					</xsl:choose>

				</div>

			</td>

			<td class="command_content_common command_content" nowrap="1">

				<span class="command_name"><xsl:value-of select='$cmdNode/@name'/>&#160;&#160;</span>

				<span class="command_shortcut">&#160;&#160;<xsl:value-of select='$cmdNode/@shortcut'/></span>

			</td>

			<td class="command_arrow_common command_arrow">

				<div><xsl:if test='command'><img src="../apt/images/commandlist.gif"/></xsl:if></div>

				

				<xsl:call-template name='commandList'/>

			</td>

		</tr>



	</xsl:template>



	<!-- Template for separator -->	

	<xsl:template name='separator'>

		<xsl:choose>

			<xsl:when test='parent::commandbar'>

				<xsl:call-template name='commandbarSeparator'/>

			</xsl:when>

			<xsl:when test='parent::command'>

				<xsl:call-template name='commandSeparator'/>

			</xsl:when>

		</xsl:choose>

	</xsl:template>



	<!-- Template for horizontal separator in command bar -->	

	<xsl:template name='commandbarSeparator'>

		<td class="separator" level="0">&#160;</td>

	</xsl:template>



	<!-- Template for vertical separator in command list -->	

	<xsl:template name='commandSeparator'>

		<xsl:variable name='level' select='count(ancestor::*[name()="command"])'/>

		<tr class="separator" level="{$level}">

			<td class="separator_icon"></td>

			<td class="separator_line" colspan="2"></td>

		</tr>

	</xsl:template>



</xsl:stylesheet>

